/* frgpasswd.c
 *
 * lets a user change both his SHADOW and SAMBA password
 *
 * copyright (c) 2000 by Knut Grahlmann <Knut.Grahlmann@bigfoot.com>
 * initial release 0.1 on 2000-04-07 by Knut Grahlmann <Knut.Grahlmann@bigfoot.com>
 * version 0.2 on 2000-07-25 by Knut Grahlmann <Knut.Grahlmann@bigfoot.com>
 *
 * Parts of the program are taken from setpwnam.c (by
 * Salvatore Valente <svalente@mit.edu>) and passwd.c (by Peter Orbaek <poe@daimi.aau.dk>)
 *
 * Thanks to Michael, who helped me with that gcc-stuff.
 *
 * !!! IMPORTANT !!!
 * -Compile with the -lcrypt option!
 * -This program needs to be chmod +s''ed by root to be able to access the /etc/shadow file.
 * -Changing the SAMBA password only works with smbpasswd of Samba > 2.0,
 * since this one has the command line switch -s.
 * !!! IMPORTANT !!!
 *
 * *****
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
*/

#define _XOPEN_SOURCE
#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <pwd.h>
#include <errno.h>
#include <signal.h>
#include <shadow.h>
#include <time.h>

#define SHADOW_FILE "/etc/shadow"
#define PWD_LEN 8
#define SMBPASSWD "/usr/bin/smbpasswd"
#define SHADOW_GROUP 15

// you shouldn't need to change anything below this line
// **********************************************************************

int check_passwd(char *pwdstr);
void clean_up(int quit);

char command[128];
char *dummy;
// +2 so that the new password can be checked for "oversize"
char newpwd[PWD_LEN+2];
// +1 for the \0
char newpwdc[PWD_LEN+1];
char oldpwd[PWD_LEN+1];
char salt[2];
char *tmp_path;
char *user;

FILE *sd_file;
FILE *tmp_file;

int counter;
int pwdlen=PWD_LEN;
int user_root=0;

struct spwd *sd_list;


// **********************************************************************
main(int argc, char **argv) {

// code taken from the passwd.c file ->
// these declarations have to be inside main(); I don't know why
#define false 0
#define true 1

#define ascii_to_bin(c) ((c)>='a'?(c-59):(c)>='A'?((c)-53):(c)-'.')
#define bin_to_ascii(c) ((c)>=38?((c)-38+'a'):(c)>=12?((c)-12+'A'):(c)+'.')

typedef int boolean;

int buflen = 256;
int contlen;
int namelen;
char *linebuf = malloc(buflen);
boolean found;
time_t tm;
// <-

switch(argc) {
case 1:
	user=getenv("USER");
	break;
case 2:
	if (getuid() != 0) {
		printf("Only root is allowed to change another user's password!\n");
		exit(1);
	} else {
		user=argv[1];
		printf("Changing password for ");
		printf(user);
		printf(".\n");
		user_root=1;
	}
}


if ((sd_list=getspnam(user)) == 0 ) {
	perror("Could not read the shadow-file");
	user="";
	exit(1);
}

if (user_root == 0) {
	if ((dummy=getpass("OLD password:")) < 0) {
		perror("Reading old password failed");
		clean_up(1);
	}
	if (strcmp(crypt(dummy,sd_list->sp_pwdp),sd_list->sp_pwdp)) {
		printf("Wrong password, nincompoop.\n");
		printf("Aborting.\n");
		clean_up(1);
	}
	strncpy(oldpwd,dummy,PWD_LEN);
}

printf("Enter the new password (mininum of 6, maximum of %i characters).\n",pwdlen);

again:
if ((dummy=getpass("NEW password:")) < 0) {
	perror("Reading new password failed");
	clean_up(1);
}

// one more byte has to be copied so that newpwd can be controlled for "oversize"
strncpy(newpwd,dummy,PWD_LEN+1);

if ((check_passwd(newpwd))) {
	printf("Aborting.\n");
	clean_up(1);
}

if ((dummy=getpass("Retype NEW password:")) < 0) {
	perror("Reading new password's check failed");
	clean_up(1);
}
strncpy(newpwdc,dummy,PWD_LEN);

// erase the password in memory
dummy="";

if (strncmp(newpwd,newpwdc,strlen(newpwd))) {
	printf("Passwords do not match, try again.\n");
	goto again;
}

// code taken from the passwd.c file ->
time(&tm); tm ^= getpid();
salt[0] = bin_to_ascii(tm & 0x3f);
salt[1] = bin_to_ascii((tm >> 6) & 0x3f);
// <-

if ((tmp_path=tmpnam(tmp_path))<0) {
	perror("Could not create unique filename for the temp file");
	clean_up(1);
}

sd_list->sp_pwdp=crypt(newpwd,salt);

sd_file=fopen(SHADOW_FILE,"r");
tmp_file=fopen(tmp_path,"w+");

chmod(tmp_path,0600);

// code taken from the setpwnam.c file ->
namelen=strlen(sd_list->sp_namp);
found=false;

while (fgets(linebuf, buflen, sd_file) != NULL) {
	contlen = strlen(linebuf);
	while (linebuf[contlen-1] != '\n' && !feof(sd_file)) {
	    // Extend input buffer if it failed getting the whole line

	    // So now we double the buffer size
	    buflen *= 2;

	    linebuf = realloc(linebuf, buflen);
	    if (linebuf == NULL) clean_up;

	    // And fill the rest of the buffer
	    if (fgets(&linebuf[contlen], buflen/2, sd_file) == NULL) break;
	    contlen = strlen(linebuf);
      
	    // That was a lot of work for nothing.  Gimme perl!
	    // I AGREE!! Knut
	}
	// Is this the username we were sent to change?
	if (!found && linebuf[namelen] == ':' && !strncmp(linebuf, sd_list->sp_namp, namelen)) {
		setspent();
		putspent(sd_list,tmp_file);
		endspent();
	 	found = true;
	    	continue;
	}
	// Nothing in particular happened, copy input to output
	fputs(linebuf, tmp_file);
}
// <-

fclose(sd_file);

fclose(tmp_file);

if (lckpwdf()<0) {
	perror("Could not lock the shadow-file");
	clean_up(1);
}

if (rename(tmp_path,SHADOW_FILE)<0) {
	perror("Could not rename the temporary password file");
	unlink(tmp_path);
	clean_up(1);
}

if (chown(SHADOW_FILE,0,SHADOW_GROUP)<0) {
	perror("Could not set the proper group for the shadow file.\nPlease inform your system administrator.\n");
	printf("Your SHADOW password however got changed.\n");
	clean_up(1);
}
	
if (chmod(SHADOW_FILE,0640)<0) {
	perror("Could not set proper permissions on the shadow file.\nPlease inform your system administrator.\n");
	printf("Your SHADOW password however got changed.\n");
	clean_up(1);
}

ulckpwdf();

printf("\nfirst step completed: SHADOW password changed\n");

if (user_root == 0) {
	strcpy(command,"echo -e \"");
	strcat(command,oldpwd);
	strcat(command,"\\n");
	strcat(command,newpwd);
	strcat(command,"\\n");
	strcat(command,newpwd);
	strcat(command,"\\n");
	strcat(command,"\" | ");
	strcat(command,SMBPASSWD);
	strcat(command," -s ");
	strcat(command," > /dev/null");
} else {
	strcpy(command,SMBPASSWD);
	strcat(command," ");
	strcat(command,user);
	strcat(command," ");
	strcat(command,newpwd);
	strcat(command," > /dev/null");
}	

//smbpasswd doesn't like to run setuid root
seteuid(getuid());

if (system(command)==256) {
	perror("smbpasswd failed");
	printf("Aborting.\n");
	clean_up(1);
}

printf("second step completed: SAMBA password changed\n");

clean_up(0);

// finally
printf("\nHave a nice day...\n");
return 0;
} //main


int check_passwd(char *pwdstr) {
	if (strlen(pwdstr) > pwdlen) {
		printf("Password too long (maximum %i characters).\n",pwdlen);
		pwdstr="";
		return -1;
	}
	if (strlen(pwdstr) < 6) {
		printf("Password too short (minimum 6 characters).\n");
		pwdstr="";
		return -1;
	}
	if (!(strncmp(pwdstr,oldpwd,strlen(pwdstr)))) {
		printf("You cannot reuse the old password.\n");
		pwdstr="";
		return -1;
	}
// here is the place to add additional password checks
	return 0;
}

void clean_up(int quit) {
	user="";
	user_root=0;
	for (counter=0;counter>pwdlen+1;counter++) {
		oldpwd[counter]=' ';
		newpwd[counter]=' ';
		newpwdc[counter]=' ';
	}
	sd_list->sp_namp="";
        sd_list->sp_pwdp="";
        sd_list->sp_lstchg=0;
        sd_list->sp_min=0;
        sd_list->sp_max=0;
        sd_list->sp_warn=0;
        sd_list->sp_inact=0;
        sd_list->sp_expire=0;
        sd_list->sp_flag=0;
	if (quit==1) {
		exit(1);
	}
}
