#!/usr/bin/perl -w

# script for mounting a novell home-folder into a home folder on a linux box
# The script is part of NOVACS which is published under the terms of the GPL
# (for details read the LICENSE file).

# originally written 02/11/1999-02/19/1999 by Knut Grahlmann <Knut.Grahlmann@bigfoot.com>
# Thanks to Mrs. Jones from Albert Einstein High School in Kensington, MD

# modified for publication 08/04/1999 by Knut Grahlmann

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# Unfortunately, I can't test this script anymore;
# don't have a Novell server at home.
# However, it should work.
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

# requirements:
#	two folders "dummy" and "locks" in the cgi-bin folder
#		(eg. /usr/httpd/cgi-bin); owner wwwrun and group root
#	one file "errors"; same rights, same place


use CGI qw(:standard);

# things you need to configure:
# -change the three variables below
# -make the subs find_servername and make_link fit your needs
# -also check novellumount.pl

$cgi_path="/usr/local/httpd/cgi-bin";	# the path to the cgi-bin folder; saves writing
$server_url="http://";	# needed for making a link to the umount-HTML-file
$hostname="";		# needed in one error message

sub find_servername {
# searches the $_ for 0-9; if one is found, it must be a student
# since teachers don't have numbers in their IDs

	if (/[0-9]/)
	{
		# students are on 2
#CHANGE_SERVER
		$server="";
		$usertype="student";
	
		# bad solution to find the graduation year; cuts six times the last character
		$_=$user;
		chop($_);chop($_);chop($_);chop($_);chop($_);chop($_);
		$graduation_year=$_;
	}
	else
	{
		# teachers are on 3
#CHANGE_SERVER
		$server="";
		$usertype="staff";
	}
}

sub make_link {
# creates a symbolik link in the linux-folder of the user
# I make a link because if a user would find eg. sys/homedirs/00/00610217 in her
# folder, she would probably freak out and cry for her mama

	if ($usertype eq "student") {
		# students have a different folder-structure than teachers
		if ((system("/bin/ln -s $cgi_path/dummy/$user/sys/homedirs/$graduation_year/$user /home/$user/novell"))) {
			$error_message=$!;
			$error="link";
			&error_handling;
			exit;
		}		
	}
	else {
		if ((system("/bin/ln -s $cgi_path/dummy/$user/sys/Homedirs/Staff/$user /home/$user/novell"))) {
			$error_message=$!;
			$error="link";
			&error_handling;
			exit;
	}
}


# these variables are declared just to have an overview;
# no need to configure anything
$password="";			# stores the provided password
$user="";			# stores the provided username
$server="";			# the name of the Novellserver
$usertype="";			# either student or staff;
				# this is because on EHS_2 it's sys/homedirs and on
				# EHS_3 sys/Homedirs; linux is picky about cases
$graduation_year="";		# last two digits, eg 00
				# needed for mounting the dummy into "real" homefolder
				# (e.g. $cgi_path/dummy/$user/sys/homedirs/00 <-
$error="";			# saves the error which is analysed by sub error_handling
$error_message="";		# saves the error message for displaying in HTML-output

# initializes the linux ipx-socket for use with Novell
# the socket gets installed on device eth1 (the "internal" one
# with frametype 802.3
# THIS IS BETTER DONE BY A /sbin/init.d-script; but just in case...
#system("/usr/bin/ipx_configure delall");
#system("/usr/bin/ipx_configure add -p eth1 802.3");

# gets the username and the password from the "commandline" of the script
$password=param("password");
$_=$user=param("user");

&find_servername;

# checks if the user has an account on this machine
if (!(-e "/home/$user")) {
	$error="no_account";
	&error_handling;
	exit;
}


# creates (if necessary) the dummy folder for the user ($cgi_path/dummy/$user
if (!(-e "$cgi_path/dummy/$user")) {
	if(!system("mkdir $cgi_path/dummy/$user")) {
		$error="dummy_folder";
		&error_handling;
		exit;
	}
}


# checks if the novellfolder is already mounted (if a lock file exists)
if (-e "$cgi_path/locks/$user") {
	$error="already_mounted";
	$error_message=$!;
	&error_handling;
	exit;
}


# mounts the novell folder in dummy
if ((system("/usr/bin/ncpmount $cgi_path/dummy/$user/ -S $server -U $user -P $password 2>$cgi_path/errors"))) {
# error messages from ncpmount are written into a file (errors) by the shell (2>...)
	$error_message=$!;
	open(ERRORS,"$cgi_path/errors");
	$_=<ERRORS>;
	close(ERRORS);
	if (/error code/) {
	# if a wrong password was provided, ncpmount produces this error message
		$error="wrong_password";
		&error_handling;
		exit;
	}
	else {
		$error="somewhat_mount";
		&error_handling;
		exit;
	}
}

# writes the password into a file. This is to have a lockfile, so that
# 1) nobody unallowed can umount the folder
# 2) the folder does not get mounted twice
if (!(open(LOCKFILE,">$cgi_path/locks/$user"))) {
	$error_message=$!;
	$error="lockfile";
	&error_handling;
	exit;
}
print LOCKFILE "$password";
close(LOCKFILE);

&make_link;

# Finally! Everything went OK! Let's give some positive feedback.
print "Content-type: text/html\n\n";
print start_html("Success!");
print h1("Your Novell-folder has been successfully mounted in your mac-folder.");
print "<p><font size=\"+2\"><b>Do not forget to <a href=\"$server_url/novellumount.html\">UMOUNT</a> your folder because otherwise you will not be able to log on to the regular network!!</b></font>";
print end_html();
exit;


# Whenever an error is recorded by the program, this sub is called.
# It has all the usual errors "in it" and produces corresponding HTML-output
sub error_handling {
print "Content-type: text/html\n\n";

if ($error eq "link") {
	print start_html("ERROR: symbolic link"), h1("Could not create symbolic link!");
	print p("Ln returned the following error: $error_message");
	print p("Please contact the system administrator.");
	print end_html();
	system("/usr/bin/ncpumount $cgi_path/dummy/$user");
	unlink ("$cgi_path/locks/$user");
}

if ($error eq "already_mounted") {
	print start_html("ERROR: already mounted"), h1("The novell-folder you tried to mount is already mounted.");
	print p("<a href=\"$server_url/novellumount.html\">Umount</a> it before mounting.");
}

if ($error eq "dummy_folder") {
	print start_html("ERROR: dummy folder"), h1("Could not create your dummy folder!");
	print p("mkdir returned the following error: $error_message");
	print p("Please contact the system administrator.");
}

if ($error eq "wrong_password") {
	print start_html("ERROR: wrong password"), h1("You provided the wrong username/password combination.");
	print p("Please <a href=\"$server_url/novellmount.html\">try again</a>!");
}

if ($error eq "somewhat_mount") {
	print start_html("ERROR: mount"), h1("Something went wrong with the mount command.");
	print p("mount returned the following error: $error_message");
	print p("Please contact the system administrator.");
}

if ($error eq "lockfile") {
	print start_html("ERROR: lockfile"), h1("Could not create your lockfile.");
	print p("The following error was returned: $error_message");
	print p("Please contact the system administrator.");
}

if ($error eq "no_account") {
	print start_html("ERROR: no account"),h1("The name you provided does not exist on $hostname.");
	print p("Check name and try again");
	print p("You can request an account from the system administrator.");
}
print end_html();
}
