#!/usr/bin/perl -w

# script for umounting the novell home-folder from a Macshare on a Linux box.
# The script is part of NOVACS which is published under the terms of the GPL
# (for details read the LICENSE file).

# originally written 02/18/1999-02/19/1999 by Knut Grahlmann <Knut.Grahlmann@bigfoot.com>
# Thanks to Mrs. Jones from Albert Einstein High School in Kensington, MD

# modified for publication 08/04/1999 by Knut Grahlmann

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# Unfortunately, I can't test this script anymore;
# don't have a Novell server at home.
# However, it should work.
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

# requirements:
#	two folders dummy and locks; owner wwwrun group root
#	one file errors; same rights
#	all three in cgi-bin folder

# for comments on mounting see novellmount.pl


use CGI qw(:standard);


# things you need to configure
$cgi_path="/usr/local/httpd/cgi-bin";	# the path to the cgi-bin folder; saves writing
$hostname="";			# needed in one error message
$server_url="http://";


# these variables are declared just to have an overview;
# no need to configure anything
$password="";			# stores the provided password
$user="";			# stores the provided username
$error="";			# saves the error which is analysed by sub error_handling
$error_message="";		# saves the error message for displaying in HTML-output



# initializes the linux ipx-socket for use with Novell
# the socket gets installed on device eth1 (the "internal" one
# with frametype 802.3
# THIS IS BETTER DONE BY A /sbin/init.d-script; but just in case...
#system("/usr/bin/ipx_configure delall");
#system("/usr/bin/ipx_configure add -p eth1 802.3");


# gets the username and the password from the "commandline" of the script
$password=param("password");
$_=$user=param("user");


# checks if the user has an account on this machine
if (!(-e "/home/$user")) {
	$error="no_account";
	&error_handling;
	exit;
}


# checks if the novellfolder is really mounted (if a lock file exists)
if (-e "$cgi_path/locks/$user") {
	
	open(LOCKFILE,"$cgi_path/locks/$user");
	$lockfile_password=<LOCKFILE>;
	close(LOCKFILE);
	# reads the in the lockfile saved password and compares it to the provided
	# one to check if user is really the owner
	if ($lockfile_password eq $password) {
		# umounts the novellfolder from dummy/$user
		if ((system("/usr/bin/ncpumount $cgi_path/dummy/$user 2>$cgi_path/errors"))) {
		# error messages from ncpmount are written into a file (errors) by the shell (2>...)
			$error_message=$!;
			open(ERRORS,"$cgi_path/errors");
			$_=<ERRORS>;
			close(ERRORS);
			if (/busy/) {
			# if a the user still uses the novellfolder,
			# Linux can't umount it
				$error="busy";
				&error_handling;
				exit;
			}
			else {
				$error="somewhat_umount";
				&error_handling;
				exit;
			}
		}


		# deletes lockfile
		if (!(unlink("$cgi_path/locks/$user"))) {
			$error_message=$!;
			$error="lockfile";
			&error_handling;
			exit;
		}


		# deletes symbolic link in user's homefolder
		if (!(unlink("/home/$user/novell"))) {
			$error_message=$!;
			$error="link";
			&error_handling;
			exit;
		}


		# Everythink went OK.
		print "Content-type: text/html\n\n";
		print start_html("Unmounted"), h1("Your novellfolder has been sucessfully umounted!"), end_html;
		exit;
	}
	else {
		$error="wrong_password";
		&error_handling;
		exit;
	}
}
exit;


sub error_handling {
print "Content-type: text/html\n\n";

if ($error eq "link") {
	print start_html("ERROR: symbolic link"), h1("Could not delete symbolic link!");
	print p("rm returned the following error: $error_message");
	print p("Please contact the system administrator.");
	unlink ("$cgi_path/locks/$user");
}

if ($error eq "wrong_password") {
	print start_html("ERROR: wrong password"), h1("You provided the wrong username/password combination.");
	print p("Please <a href=\"$server_url/novellumount.html\">try again</a>!");
}

if ($error eq "somewhat_mount") {
	print start_html("ERROR: mount"), h1("Something went wrong with the mount command.");
	print p("mount returned the following error: $error_message");
	print p("Please contact the system administrator.");
}

if ($error eq "lockfile") {
	print start_html("ERROR: lockfile"), h1("Could not delete your lockfile.");
	print p("The following error was returned: $error_message");
	print p("Please contact the system administrator.");
}

if ($error eq "no_account") {
	print start_html("ERROR: no account"),h1("The name you provided does not exist on $hostname.");
	print p("Check name and try again");
	print p("You can request an account from the system administrator.");
}

if ($error eq "busy") {
	print start_html("ERROR: resource busy"),h1("Could not umount your folder.");
	print p("This is because you are currently accessing it.");
	print p("End all accesses and <a href=\"$server_url/novellumount.html\">try again</a>!");
}

print end_html();
}
